@extends('layouts.app')

@section('main')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Create Subscription</h3>
                </div>
                <div class="card-body">
                    @if(isset($existingSubscription))
                        <div class="alert
                            @if($existingSubscription->status == 'pending') alert-warning
                            @elseif($existingSubscription->status == 'cancelled') alert-danger
                            @elseif($existingSubscription->status == 'expired') alert-secondary
                            @else alert-info
                            @endif
                            alert-dismissible fade show" role="alert">
                            <strong>
                                @if($existingSubscription->status == 'pending') Subscription Pending:
                                @elseif($existingSubscription->status == 'cancelled') Subscription Cancelled:
                                @elseif($existingSubscription->status == 'expired') Subscription Expired:
                                @else Status: {{ ucfirst($existingSubscription->status) }}:
                                @endif
                            </strong>
                            @if($existingSubscription->status == 'pending')
                                You have a subscription request pending approval. Please wait for admin approval before creating a new one.
                            @elseif($existingSubscription->status == 'cancelled')
                                Your previous subscription was cancelled. You can create a new subscription if needed.
                            @elseif($existingSubscription->status == 'expired')
                                Your previous subscription has expired. You can create a new subscription if needed.
                            @else
                                Your subscription status is {{ ucfirst($existingSubscription->status) }}.
                            @endif
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    <form action="{{ route('subscriptions.store') }}" method="POST" @if(isset($existingSubscription) && $existingSubscription->status == 'pending') style="pointer-events: none; opacity: 0.5;" @endif>
                        @csrf
                        <div class="form-group">
                            <label for="plan_id">Plan</label>
                            <select class="form-control" id="plan_id" name="plan_id" required @if(isset($existingSubscription) && $existingSubscription->status == 'pending') disabled @endif>
                                @foreach($plans as $plan)
                                    <option value="{{ $plan->id }}">{{ $plan->name }} - ${{ $plan->price }}/{{ $plan->interval }}</option>
                                @endforeach
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary" @if(isset($existingSubscription) && $existingSubscription->status == 'pending') disabled @endif>Create</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
